<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Models\Movie;
use Illuminate\Http\Request;

class MovieController extends Controller
{
    public function index()
    {
        return Movie::latest()->get();
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string',
            'url' => 'required|url',
            'description' => 'nullable|string',
            'category' => 'nullable|string',
            'poster_url' => 'nullable|url',
        ]);

        return Movie::create($validated);
    }

    public function show(Movie $movie)
    {
        return $movie;
    }

    public function update(Request $request, Movie $movie)
    {
        $validated = $request->validate([
            'title' => 'required|string',
            'url' => 'required|url',
            'description' => 'nullable|string',
            'category' => 'nullable|string',
            'poster_url' => 'nullable|url',
        ]);

        $movie->update($validated);
        return $movie;
    }

    public function destroy(Movie $movie)
    {
        $movie->delete();
        return response()->json(null, 204);
    }
}
