<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ResellerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return \App\Models\Reseller::all();
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string',
            'balance' => 'required|numeric',
        ]);

        $validated['api_key'] = \Illuminate\Support\Str::random(32);
        $validated['status'] = 'active';

        return \App\Models\Reseller::create($validated);
    }

    public function show(\App\Models\Reseller $reseller)
    {
        return $reseller;
    }

    public function update(Request $request, \App\Models\Reseller $reseller)
    {
        $validated = $request->validate([
            'name' => 'sometimes|string',
            'balance' => 'sometimes|numeric',
            'status' => 'sometimes|string',
        ]);

        if ($request->has('balance')) {
             // Logic for documenting transaction could go here
        }

        $reseller->update($validated);
        return $reseller;
    }

    public function destroy(\App\Models\Reseller $reseller)
    {
        $reseller->delete();
        return response()->noContent();
    }
}
