<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class FailoverController extends Controller
{
    public function report(Request $request)
    {
        $validated = $request->validate([
            'channel_id' => 'required|exists:channels,id',
            'event' => 'required|string',
            'reason' => 'nullable|string',
            'new_line' => 'nullable|string|in:A,B',
        ]);

        $channel = \App\Models\Channel::find($validated['channel_id']);

        if ($validated['event'] === 'failover') {
            $channel->update([
                'current_line' => $validated['new_line'],
                'status' => 'online',
            ]);
        } elseif ($validated['event'] === 'offline') {
            $channel->update(['status' => 'offline']);
        }

        // Create Notification
        \App\Models\Notification::create([
            'title' => 'تم رصد عطل في قناة: ' . $channel->name,
            'message' => 'السبب: ' . ($validated['reason'] ?? $validated['event']) . '. الخط المفعل حالياً: ' . $validated['new_line'],
            'type' => $validated['event'] === 'failover' ? 'warning' : 'error'
        ]);

        return response()->json(['message' => 'Report processed']);
    }
}
