<?php

namespace App\Http\Controllers\Api\Reseller;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CodeController extends Controller
{
    public function index()
    {
        $reseller = \App\Models\Reseller::first(); // Demo logic
        return $reseller->activationCodes()->latest()->get();
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'type' => 'required|string|in:live,vod,trial',
            'count' => 'required_without:code|integer|min:1|max:50',
            'code' => 'nullable|string|unique:activation_codes,code|min:4|max:20',
            'mode' => 'required|string|in:auto,manual',
        ]);

        $reseller = \App\Models\Reseller::first(); // Demo logic

        $codes = [];
        if ($validated['mode'] === 'manual') {
            $codes[] = \App\Models\ActivationCode::create([
                'code' => strtoupper($validated['code']),
                'reseller_id' => $reseller->id,
                'status' => 'inactive',
                'type' => $validated['type'],
            ]);
        } else {
            for ($i = 0; $i < $validated['count']; $i++) {
                $status = 'inactive';
                $newCode = strtoupper(\Illuminate\Support\Str::random(10));
                
                // Ensure uniqueness in loop (simplistic check)
                while (\App\Models\ActivationCode::where('code', $newCode)->exists()) {
                    $newCode = strtoupper(\Illuminate\Support\Str::random(10));
                }

                $codes[] = \App\Models\ActivationCode::create([
                    'code' => $newCode,
                    'reseller_id' => $reseller->id,
                    'status' => $status,
                    'type' => $validated['type'],
                ]);
            }
        }

        // Trigger notification
        \App\Models\Notification::create([
            'title' => 'توليد أكواد جديدة',
            'message' => 'تم توليد عدد ' . count($codes) . ' كود بنجاح من قبل الموزع.',
            'type' => 'success'
        ]);

        return response()->json($codes, 201);
    }
}
