<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Reseller extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'balance',
        'api_key',
        'status',
    ];

    public function activationCodes()
    {
        return $this->hasMany(ActivationCode::class);
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }
}
