<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IPTV Pro — لوحة التحكم</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700;900&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            font-family: 'Cairo', sans-serif;
            background: #0a0d1a;
            color: #fff;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            overflow-x: hidden;
        }

        /* Animated background */
        body::before {
            content: '';
            position: fixed;
            inset: 0;
            background:
                radial-gradient(ellipse 80% 60% at 20% 20%, rgba(59, 130, 246, 0.15) 0%, transparent 60%),
                radial-gradient(ellipse 60% 60% at 80% 80%, rgba(139, 92, 246, 0.12) 0%, transparent 60%),
                radial-gradient(ellipse 40% 40% at 50% 50%, rgba(236, 72, 153, 0.06) 0%, transparent 60%);
            z-index: -1;
        }

        /* Floating orbs */
        .orb {
            position: fixed;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.4;
            animation: float 8s ease-in-out infinite;
            z-index: -1;
        }
        .orb-1 { width: 400px; height: 400px; background: rgba(59,130,246,0.3); top: -100px; right: -100px; animation-delay: 0s; }
        .orb-2 { width: 300px; height: 300px; background: rgba(139,92,246,0.3); bottom: -80px; left: -80px; animation-delay: -4s; }
        .orb-3 { width: 200px; height: 200px; background: rgba(236,72,153,0.2); top: 50%; left: 50%; animation-delay: -2s; }

        @keyframes float {
            0%, 100% { transform: translateY(0) scale(1); }
            50% { transform: translateY(-30px) scale(1.05); }
        }

        /* Hero */
        .hero {
            text-align: center;
            margin-bottom: 60px;
        }

        .logo {
            width: 90px; height: 90px;
            background: linear-gradient(135deg, #3b82f6, #8b5cf6);
            border-radius: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 24px;
            box-shadow: 0 0 60px rgba(59,130,246,0.5);
            animation: pulse-glow 3s ease-in-out infinite;
        }

        @keyframes pulse-glow {
            0%, 100% { box-shadow: 0 0 40px rgba(59,130,246,0.4); }
            50% { box-shadow: 0 0 80px rgba(59,130,246,0.7); }
        }

        .hero h1 {
            font-size: 2.8rem;
            font-weight: 900;
            background: linear-gradient(135deg, #60a5fa, #a78bfa, #f472b6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 12px;
        }

        .hero p {
            color: #94a3b8;
            font-size: 1.1rem;
        }

        /* Cards Grid */
        .cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
            gap: 20px;
            max-width: 1000px;
            width: 100%;
            padding: 0 20px;
        }

        .card {
            background: rgba(255,255,255,0.04);
            border: 1px solid rgba(255,255,255,0.08);
            border-radius: 20px;
            padding: 32px 28px;
            text-decoration: none;
            color: inherit;
            transition: all 0.3s ease;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            backdrop-filter: blur(12px);
        }

        .card::before {
            content: '';
            position: absolute;
            inset: 0;
            opacity: 0;
            transition: opacity 0.3s;
            border-radius: 20px;
        }

        .card:hover {
            transform: translateY(-6px);
            border-color: rgba(255,255,255,0.2);
        }

        .card:hover::before { opacity: 1; }

        /* Card colors */
        .card-blue::before  { background: linear-gradient(135deg, rgba(59,130,246,0.1), transparent); }
        .card-purple::before { background: linear-gradient(135deg, rgba(139,92,246,0.1), transparent); }
        .card-green::before { background: linear-gradient(135deg, rgba(16,185,129,0.1), transparent); }
        .card-pink::before  { background: linear-gradient(135deg, rgba(236,72,153,0.1), transparent); }

        .card:hover.card-blue  { border-color: rgba(59,130,246,0.5); box-shadow: 0 20px 60px rgba(59,130,246,0.15); }
        .card:hover.card-purple { border-color: rgba(139,92,246,0.5); box-shadow: 0 20px 60px rgba(139,92,246,0.15); }
        .card:hover.card-green { border-color: rgba(16,185,129,0.5); box-shadow: 0 20px 60px rgba(16,185,129,0.15); }
        .card:hover.card-pink  { border-color: rgba(236,72,153,0.5); box-shadow: 0 20px 60px rgba(236,72,153,0.15); }

        .card-icon {
            width: 56px; height: 56px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.6rem;
            margin-bottom: 20px;
        }

        .bg-blue   { background: rgba(59,130,246,0.2); }
        .bg-purple { background: rgba(139,92,246,0.2); }
        .bg-green  { background: rgba(16,185,129,0.2); }
        .bg-pink   { background: rgba(236,72,153,0.2); }

        .card h3 {
            font-size: 1.15rem;
            font-weight: 700;
            margin-bottom: 8px;
        }

        .card p {
            color: #64748b;
            font-size: 0.875rem;
            line-height: 1.7;
        }

        .card-badge {
            display: inline-block;
            margin-top: 16px;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .badge-blue   { background: rgba(59,130,246,0.2);  color: #60a5fa; }
        .badge-purple { background: rgba(139,92,246,0.2); color: #a78bfa; }
        .badge-green  { background: rgba(16,185,129,0.2);  color: #34d399; }
        .badge-pink   { background: rgba(236,72,153,0.2);  color: #f472b6; }

        .card-url {
            position: absolute;
            bottom: 20px;
            left: 20px;
            font-size: 0.7rem;
            color: #334155;
            font-family: monospace;
        }

        /* API Status */
        .api-status {
            margin-top: 48px;
            display: flex;
            align-items: center;
            gap: 8px;
            color: #475569;
            font-size: 0.8rem;
        }

        .status-dot {
            width: 8px; height: 8px;
            border-radius: 50%;
            background: #10b981;
            animation: pulse-dot 2s ease-in-out infinite;
        }

        @keyframes pulse-dot {
            0%, 100% { opacity: 1; transform: scale(1); }
            50% { opacity: 0.5; transform: scale(1.5); }
        }

        /* Footer */
        footer {
            margin-top: 48px;
            color: #1e293b;
            font-size: 0.8rem;
            text-align: center;
        }

        .arrow {
            display: inline-block;
            margin-right: 8px;
            transition: transform 0.3s;
        }
        .card:hover .arrow { transform: translateX(-6px); }
    </style>
</head>
<body>
    <!-- Animated orbs -->
    <div class="orb orb-1"></div>
    <div class="orb orb-2"></div>
    <div class="orb orb-3"></div>

    <!-- Hero -->
    <div class="hero">
        <div class="logo">
            <svg width="40" height="40" fill="none" viewBox="0 0 24 24" stroke="white" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M15 10l4.553-2.069A1 1 0 0121 8.82v6.36a1 1 0 01-1.447.894L15 14M3 8a2 2 0 012-2h8a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2V8z" />
            </svg>
        </div>
        <h1>IPTV Pro Platform</h1>
        <p>اختر الواجهة التي تريد الوصول إليها</p>
    </div>

    <!-- Cards -->
    <div class="cards">
        <!-- User Dashboard -->
        <a href="http://localhost:5174" class="card card-blue" target="_blank">
            <div class="card-icon bg-blue">👤</div>
            <h3>لوحة المستخدم</h3>
            <p>إدارة الاشتراكات والأجهزة وتفعيل الأكواد ومشاهدة القنوات</p>
            <div class="card-badge badge-blue"><span class="arrow">←</span> دخول الآن</div>
            <span class="card-url">localhost:5174</span>
        </a>

        <!-- IPTV Player -->
        <a href="http://localhost:4200" class="card card-purple" target="_blank">
            <div class="card-icon bg-purple">📺</div>
            <h3>بلاير IPTV</h3>
            <p>مشاهدة القنوات وتحميل قوائم التشغيل M3U وإدارة المفضلة</p>
            <div class="card-badge badge-purple"><span class="arrow">←</span> فتح البلاير</div>
            <span class="card-url">localhost:4200</span>
        </a>

        <!-- Admin Panel -->
        <a href="/api/admin/stats" class="card card-green" target="_blank">
            <div class="card-icon bg-green">🛠️</div>
            <h3>لوحة الإدارة (API)</h3>
            <p>إحصائيات النظام، القنوات، الموزعين وأكواد التفعيل عبر REST API</p>
            <div class="card-badge badge-green"><span class="arrow">←</span> إحصائيات الأدمن</div>
            <span class="card-url">localhost:8000/api/admin/stats</span>
        </a>

        <!-- API Documentation -->
        <a href="/api/live" class="card card-pink" target="_blank">
            <div class="card-icon bg-pink">⚡</div>
            <h3>Backend API</h3>
            <p>عرض القنوات المتاحة — نقطة الوصول لجميع الـ APIs للمطورين</p>
            <div class="card-badge badge-pink"><span class="arrow">←</span> عرض القنوات</div>
            <span class="card-url">localhost:8000/api/live</span>
        </a>
    </div>

    <!-- API Status -->
    <div class="api-status">
        <div class="status-dot"></div>
        الـ Backend API يعمل بشكل طبيعي — الإصدار 1.0.0
    </div>

    <footer>
        &copy; <?php echo e(date('Y')); ?> IPTV Pro Platform &mdash; All rights reserved
    </footer>
</body>
</html>
<?php /**PATH C:\Users\Soliman\Desktop\iptv\backend\resources\views/landing.blade.php ENDPATH**/ ?>